/* eslint-disable no-new-func */

import React from 'react';
import PropTypes from 'prop-types';
import getValue from 'utils/getValue';
import Node from './Node';

const INIT_STATE = {
  values: {},
  disabled: {},
};

class FormBuilder extends React.Component {
  static childContextTypes = {
    getInputProps: PropTypes.func.isRequired,
  };

  static defaultOnChange = (value, pValue, name, values) => {
    if (name) {
      return { ...values, [name]: value };
    }

    return values;
  };

  static defaultDisabled = () => ({});

  static defaultValidate = values => {
    let isValid = true;
    // eslint-disable-next-line no-restricted-syntax
    for (const key in values) {
      // eslint-disable-next-line eqeqeq
      if (values[key] == 0) {
        isValid = false;
        break;
      }
    }

    return isValid;
  };

  static filterDisabledValues = (values, disabled) => {
    const newValues = {};

    // eslint-disable-next-line no-restricted-syntax
    for (const key in values) {
      // eslint-disable-next-line eqeqeq
      if (!disabled[key]) {
        newValues[key] = values[key];
      }
    }

    return newValues;
  };

  constructor(props) {
    super(props);

    this.metaSetup();
    this.state = this.getIntialState();
  }

  getChildContext() {
    return { getInputProps: this.getInputProps };
  }

  componentDidMount() {
    this.handleChange();
  }

  getIntialState() {
    const { initialValues } = this.props;
    const { initialValues: metaInitialValues } = this.props.meta;

    const state = { ...INIT_STATE };
    state.values = initialValues || metaInitialValues;

    return state;
  }

  getData() {
    const { disabled = {}, values } = this.state;
    return Object.keys(values).reduce((pv, key) => {
      if (!disabled[key]) {
        return { ...pv, [key]: values[key] };
      }

      return pv;
    }, {});
  }

  getInputProps = name => ({
    onChange: this.handleChange,
    value: this.state.values[name],
    disabled: this.props.disabled || this.state.disabled[name],
  });

  metaSetup() {
    const { onChange, validate, disabled } = this.props.meta;

    this.metaOnChange = onChange
      ? new Function('value, pValue, name, values', onChange)
      : FormBuilder.defaultOnChange;
    this.metaDisabled = disabled ? new Function('values', disabled) : FormBuilder.defaultDisabled;
    this.metaValidate = validate ? new Function('values', validate) : FormBuilder.defaultValidate;
  }

  isValid() {
    return this.state.isValid;
  }

  reset() {
    this.setState(this.getIntialState(), this.handleChange);
  }

  handleChange = e => {
    try {
      let name;
      let value;
      if (e) {
        ({ name } = e.target);
        value = getValue(e);
      }

      const values = this.metaOnChange(value, this.state.values[name], name, this.state.values);
      const isValid = this.metaValidate(values);
      const disabled = this.metaDisabled(values);
      this.setState({ values, disabled, isValid });
      if (typeof this.props.onChange === 'function') {
        this.props.onChange(FormBuilder.filterDisabledValues(values, disabled));
      }
    } catch (error) {
      console.error(error);
    }
  };

  unstable_handleError(e) {
    console.error(e);
    this.setState({ error: true });
  }

  render() {
    if (this.state.error) {
      return <span>Ошибка в описании формы</span>;
    }

    return React.createElement(Node, this.props.meta.form);
  }
}

export default FormBuilder;
