import React from 'react';
import PropTypes from 'prop-types';
import COMPONENTS from './components';

const Node = ({ component, content, props }, { getInputProps }) => {
  let renderedChildren;
  if (content != null) {
    if (Array.isArray(content)) {
      renderedChildren = content.map(node => React.createElement(Node, node));
    } else if (typeof content === 'object') {
      renderedChildren = React.createElement(Node, content);
    } else {
      renderedChildren = content;
    }
  }

  let passProps = props;
  if (props && props.name) {
    passProps = { ...props, ...getInputProps(props.name) };
    if (passProps.type === 'checkbox') {
      passProps.checked = passProps.value;
      delete passProps.value;
    }
  }

  return React.createElement(COMPONENTS[component] || component, passProps, renderedChildren);
};

Node.contextTypes = { getInputProps: PropTypes.func.isRequired };

export default Node;
