import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import css from './styles.modules.scss';

const propTypes = {
  items: PropTypes.array,
};

const ROLE = {
  Teamlead: 'Внутренняя',
  Crosslead: 'Кросс',
  Client: 'Внешняя',
};

const ITEM_CLASS = {
  Teamlead: css.item_teamlead,
  Crosslead: css.item_crosslead,
  Client: css.item_client,
};

export default class History extends React.Component {
  render() {
    const items = this.props.items;
    let index = 0;
    return (
      <table className={css.root}>
        <thead>
          <tr className={css.header}>
            <th className={css.date}>Дата</th>
            <th className={css.role}>Роль</th>
            <th className={css.name}>Автор</th>
            <th className={css.score}>Оценка</th>
            <th className={css.cell}>Степень конфликтности</th>
            <th className={css.cell}>Причина изменения</th>
            <th className={css.comment}>Комментарий</th>
          </tr>
        </thead>
        <tbody className={css.body}>{items.map(item => <Item key={index++} {...item} />)}</tbody>
      </table>
    );
  }
}

History.propTypes = propTypes;

class Item extends React.Component {
  render() {
    return (
      <tr className={ITEM_CLASS[this.props.role]}>
        <td className={css.date}>
          <FormattedDate
            value={new Date(this.props.reviewDt)}
            day="numeric"
            month="short"
            year="numeric"
            hour="numeric"
            minute="numeric"
          />
        </td>
        <td className={css.role}>{ROLE[this.props.role]}</td>
        <td className={css.name}>{this.props.author && this.props.author.name}</td>
        <td className={css.score}>{this.props.score}</td>
        <td className={css.cell}>{this.props.conflictScore}</td>
        <td className={css.cell}>
          <pre>{this.props.reasonForChange}</pre>
        </td>
        <td className={css.comment}>
          <pre>{this.props.comment}</pre>
        </td>
      </tr>
    );
  }
}
