import React from 'react';
import FilesList from 'components/FilesList';
import css from './styles.modules.scss';

export default class Review extends React.Component {
  render() {
    return (
      <div className={css.root}>
        <div className={css.header}>
          <div className={css.header__wrap}>
            <div>
              <span className={css.label}>От</span>
              {this.props.from}
            </div>
            <div>
              <span className={css.label}>Кому</span>
              {this.props.to}
            </div>
            {this.props.cc && (
              <div>
                <span className={css.label}>Копия</span>
                {this.props.cc}
              </div>
            )}
            {this.props.bcc && (
              <div>
                <span className={css.label}>
                  Скрытая<br />копия
                </span>
                {this.props.bcc}
              </div>
            )}
            <div>
              <span className={css.label}>Тема</span>
              {this.props.subject}
            </div>
            <FilesList files={this.props.files} isInline mailId={this.props.id} />
          </div>
        </div>
        {this.props.isHtml ? (
          <div className={css.body}>
            <div
              className={css.content}
              style={{ wordWrap: 'break-word' }}
              dangerouslySetInnerHTML={{ __html: this.props.body }}
            />
          </div>
        ) : (
          <div className={css.body}>
            <pre>{this.props.body}</pre>
          </div>
        )}
      </div>
    );
  }
}
