import React from 'react';
import ConflictTooltip from './ConflictTooltip';
import css from '../styles.modules.scss';

const Conflict = props => {
  const { disabled, value, onChange } = props;

  const options = [];

  for (let i = 0; i <= 10; i++) {
    options.push(
      <option key={i} value={i}>
        {i || ''}
      </option>,
    );
  }

  return (
    <div>
      <span className={css.label}>Степень конфликтности: </span>
      <select onChange={onChange} name="conflict" value={value} disabled={disabled}>
        {options}
      </select>
      {!disabled ? <ConflictTooltip /> : null}
    </div>
  );
};

export default Conflict;
