import React from 'react';
import ToolTip from 'lego/components/ToolTip';
import css from '../styles.modules.scss';

const ConflictTooltip = () => {
  const popup = (
    <div className={css.conflictPopup}>
      <p>1 - минимальный уровень конфликтности, 10 - максимальный.</p>
      <p>
        Письма, в которых указаны повторяющиеся проблемы пользователя или полное не согласие с
        действиями сотрудников, скорее всего имеют высокий уровень конфликтности – 10.
      </p>
      <p>
        Письма, в которых требуется дать консультацию или помочь с интерфейсом, скорее всего имеют
        низкий уровень конфликтности – 1.
      </p>
      <p>Промежуточные значения оценивайте из опыта работы.</p>
    </div>
  );

  return (
    <ToolTip tooltip={popup} autoZIndex padding="xs">
      <span className={css.tip}>
        <i className="material-icons">help_outline</i>
      </span>
    </ToolTip>
  );
};

export default ConflictTooltip;
