import React from 'react';

const ReasonChange = props => {
  const { onChange, reason, customReason } = props;

  return (
    <div>
      <div>
        <span>Причина изменения: </span>
        <select name="reason" value={reason} onChange={onChange}>
          <option value="0" />
          <option value="Апелляция менеджера">Апелляция менеджера</option>
          <option value="Случайно сохранил">Случайно сохранил</option>
          <option value="Нашел ошибку после">Нашел ошибку после</option>
          <option value="В регламенте отсутствуют/не точно сформулированы правила оценки">
            В регламенте отсутствуют/не точно сформулированы правила оценки
          </option>
          <option value="OTHER">Другая</option>
        </select>
      </div>
      <div hidden={reason !== 'OTHER'}>
        <div>Укажите вашу причину изменения (макс. 200 символов):</div>
        <textarea
          name="customReason"
          value={customReason}
          onChange={onChange}
          maxLength="200"
          placeholder="Причина изменения"
          rows="3"
          cols="50"
        />
      </div>
    </div>
  );
};

export default ReasonChange;
