import React from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import css from './styles.modules.scss';
import Managers from '../Managers';

export default class Review extends React.Component {
  render() {
    const { children, ui, groupIds, ...rest } = this.props;
    const id = get(this.props, 'item.id');
    const managers = get(this.props, 'list.managers');

    const childrenWithProps = React.Children.map(children, child =>
      React.cloneElement(child, {
        ...rest,
        ui,
      }),
    );

    return (
      <div className={css.root}>
        <div className={css.container}>
          <div className={css.side}>
            <Managers
              managers={managers}
              selectedId={id}
              onTabClick={this.props.setTabIndex}
              onAddItem={this.props.add}
              ui={ui}
              onFilterUpdate={this.props.onFilterUpdate}
              groupIds={groupIds}
            />
          </div>
          {childrenWithProps}
        </div>
      </div>
    );
  }
}

Review.propTypes = {
  children: PropTypes.instanceOf(Object),
  ui: PropTypes.instanceOf(Object),
  groupIds: PropTypes.number,
  setTabIndex: PropTypes.func.isRequired,
  add: PropTypes.func.isRequired,
  onFilterUpdate: PropTypes.func.isRequired,
};

Review.defaultProps = {
  children: undefined,
  ui: undefined,
  groupIds: undefined,
};
