import React from 'react';
import PropTypes from 'prop-types';
import { withRouter } from 'react-router-dom';
import Icon from 'lego/components/Icon';
import TitleChain from 'modules/heading';
import RouterLink from 'components/RouterLink';
import cx from 'classnames';
import { TRANSLATE } from 'constants/backendTypesRaw';
import { moduleRoutes } from '../../constants';
import Mark from './Mark';
import DateReview from './DateReview';
import css from './styles.modules.scss';
import tableCss from './table.modules.scss';

const CommunicationListItem = props => {
  const {
    match,
    manager: {
      manager: { login, name },
    },
    communication: { id, skipped, dt, teamleadScore, clientScore, reviewType, hasComment },
    isAddButton,
    addCommunication,
  } = props;

  return (
    <RouterLink
      to={`${moduleRoutes.base}/${id}`}
      className={cx(
        tableCss.row,
        css.item,
        skipped && css.item_skipped,
        isAddButton && css.item_isAddItem,
      )}
      activeClassName={css.item_selected}
    >
      {String(match.params.id) === String(id) && (
        <TitleChain>
          {`${new Date(dt).toLocaleDateString('ru-RU')} — [${
            TRANSLATE.TYPES[reviewType]
          }] — ${name} ${login ? ` (${login})` : ''}`}
        </TitleChain>
      )}
      {isAddButton ? (
        <button
          type="button"
          title="Оценить дополнительную коммуникацию"
          onClick={addCommunication}
          className={css.btnAdd}
        >
          +
        </button>
      ) : null}
      <DateReview date={dt} className={tableCss.date} />
      <div className={tableCss.type}>
        <span className={css.type}>{TRANSLATE.TYPES[reviewType]}</span>
      </div>
      <div className={tableCss['comment-icon']}>
        {hasComment && (
          <Icon
            pack={Icon.PACKS.FONTAWESOME}
            icon="commenting"
            title="Есть комментарий проверяющего"
          />
        )}
      </div>
      <div className={tableCss.mark}>
        <Mark mark={teamleadScore} type="teamlead" />
        <Mark mark={clientScore} type="outside" />
      </div>
    </RouterLink>
  );
};

CommunicationListItem.propTypes = {
  match: PropTypes.instanceOf(Object).isRequired,
  manager: PropTypes.instanceOf(Object).isRequired,
  communication: PropTypes.instanceOf(Object).isRequired,
  isAddButton: PropTypes.bool,
  addCommunication: PropTypes.func,
  hasComment: PropTypes.bool,
};

CommunicationListItem.defaultProps = {
  isAddButton: false,
  addCommunication: undefined,
  hasComment: false,
};

export default withRouter(CommunicationListItem);
