import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import CommunicationListItem from './CommunicationListItem';

class CommunicationListItemContainers extends Component {
  static propTypes = {
    addCommunication: PropTypes.func.isRequired,
    communication: PropTypes.instanceOf(Object).isRequired,
  }

  handleAddCommunication = (e) => {
    const { addCommunication, communication } = this.props;
    if (typeof addCommunication === 'function') {
      return addCommunication(e, { periodDt: communication.dt, after: communication.id });
    }

    return null;
  }

  render() {
    return createElement(
      CommunicationListItem,
      { ...this.props, addCommunication: this.handleAddCommunication },
    );
  }
}

export default CommunicationListItemContainers;
