import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';

const DateReview = (props) => {
  const { date, ...passPropsThrough } = props;

  return (
    <span {...passPropsThrough}>
      <FormattedDate
        value={new Date(date)}
        year="numeric"
        month="short"
        day="numeric"
      />
    </span>
  );
};

DateReview.propTypes = {
  date: PropTypes.string.isRequired,
};

export default DateReview;
