import React from 'react';
import PropTypes from 'prop-types';
import Name from 'components/Name';
import get from 'lodash/get';
import CommunicationListItemContainers from './CommunicationListItemContainers';
import css from './styles.modules.scss';

const Manager = props => {
  const { manager, isAddButton, addCommunication } = props;

  const login = <Name name={manager.manager.login} />;

  const managerScore = manager.managerScore || {};

  return (
    <div key={manager.manager.login} className={css.manager}>
      <div className={css.manager__header}>
        <span className={css.name}>
          {`${manager.manager.name}`} ({login} )&nbsp;
        </span>
        {managerScore.avgLead ? (
          <span title="Средняя внутренняя оценка" className={css.avg_lead}>
            {get(manager, 'managerScore.avgLead')}
          </span>
        ) : null}
        {managerScore.avgClient ? (
          <span title="Средняя оценка клиента" className={css.avg_client}>
            {get(manager, 'managerScore.avgClient')}
          </span>
        ) : null}
      </div>
      <div className={css.manager__data}>
        {Array.isArray(manager.items) &&
          !!manager.items.length &&
          manager.items.map(item => (
            <CommunicationListItemContainers
              key={item.id}
              communication={item}
              addCommunication={addCommunication}
              isAddButton={isAddButton}
              manager={manager}
            />
          ))}
      </div>
    </div>
  );
};

Manager.propTypes = {
  manager: PropTypes.instanceOf(Object).isRequired,
  isAddButton: PropTypes.bool,
  addCommunication: PropTypes.func,
};

Manager.defaultProps = {
  isAddButton: false,
  addCommunication: undefined,
};

export default Manager;
