import React from 'react';
import PropTypes from 'prop-types';
import ToolTip from 'lego/components/ToolTip';
import css from './styles.modules.scss';
import cssPopup from './popup.modules.scss';
import DateReview from './DateReview';

const Mark = props => {
  const { mark, type } = props;

  if (!mark) {
    return null;
  }

  const TITLE = {
    teamlead: 'Внутренняя оценка',
    cross: 'Кросс-оценка',
    outside: 'Внешняя оценка',
  };

  const { createdBy } = mark;

  const popup = (
    <div className={cssPopup.b}>
      <div className={cssPopup[`header_${type}`]}>{TITLE[type]}</div>
      <div className={cssPopup.b__content}>
        <div className={cssPopup.row}>
          <DateReview date={mark.createdOn} className={cssPopup.date} />
        </div>
        {createdBy ? <div className={cssPopup.row}>{createdBy.name}</div> : null}
        {mark.comment ? (
          <div className={cssPopup.row}>
            <span className={css.label}>Комментарий: </span>
            {mark.comment}
          </div>
        ) : null}
        {mark.reason ? (
          <div className={cssPopup.row}>
            <span className={css.label}>Причина: </span>
            {mark.reason}
          </div>
        ) : null}
      </div>
    </div>
  );

  return (
    <ToolTip tooltip={popup} stopPropagation className={css[`markTooltip_${type}`]}>
      <span className={css[`points_${type}`]}>{mark.score}</span>
    </ToolTip>
  );
};

Mark.propTypes = {
  mark: PropTypes.instanceOf(Object),
  type: PropTypes.string,
};

Mark.defaultProps = {
  mark: undefined,
  type: '',
};

export default Mark;
