import React from 'react';
import { cnTheme } from '@yandex-lego/components/Theme';
import { crmTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import FieldDateRange from 'requestForms/components/FieldDateRange';
import FieldTreeSelect from 'requestForms/components/FieldTreeSelect';
import cx from 'classnames';
import TextInput from 'lego/redux-form/TextInput';
import CheckBox from 'lego/redux-form/CheckBox';
import Select from 'lego/redux-form/Select';
import { default as backendTypes, TRANSLATE } from 'constants/backendTypesRaw';
import css from './styles.modules.scss';

const groupItemsAdapter = (items) => {
  if (Array.isArray(items)) {
    return items.map((item) => ({ value: String(item.value), content: item.caption }));
  }

  return [];
};

const typeItemsAdapter = (items) => {
  if (!Array.isArray(items)) {
    return [];
  }

  return items.map((item) => ({
    value: String(item),
    content: TRANSLATE.TYPES[item],
  }));
};

const ReviewFilter = (props) => {
  const { items: groupItems, handleSubmit, selectedGroups } = props;

  return (
    <form
      className={cx(css.review_filter, cnTheme({ root: crmTheme.root }))}
      onSubmit={handleSubmit}
    >
      <div className={css.formRow}>
        <Field
          className={css.formField}
          labelPrefix="Категория "
          labelWidth={100}
          component={FieldTreeSelect}
          zIndexGroupLevel={4}
          name="categoryIds"
          size="xs"
          mode="hierarchy-check"
          endpoint="/view/support/category/list/all"
          defaultValueText="Все"
          props={{ name: 'categoryId' }}
        />
      </div>
      <div className={css.formRow}>
        <Field
          name="groupIds"
          component={Select}
          size="xs"
          width="max"
          className={cx(css.formField, css.review_filter__select)}
          placeholder="Группа"
          options={groupItemsAdapter(groupItems)}
          resetItem="Any"
          hasEmptyValue={false}
          value={selectedGroups}
        />
      </div>
      <div className={css.formRow}>
        <Field
          name="communicationTypes"
          component={Select}
          size="xs"
          width="max"
          className={cx(css.formField, css.review_filter__select)}
          hasEmptyValue={false}
          options={typeItemsAdapter([
            backendTypes.TYPES.MAIL,
            backendTypes.TYPES.SP_TICKET,
            backendTypes.TYPES.CALL,
            backendTypes.TYPES.REQUEST_MESSAGE,
            backendTypes.TYPES.CHAT_CHUNK,
          ])}
          placeholder="Тип"
        />
      </div>
      <div className={css.formRow}>
        <FieldDateRange startName="communicationFrom" endName="communicationTo" size="xs" />
      </div>
      <div className={css.formRow}>
        <Field
          name="pointsAbove"
          component={TextInput}
          size="xs"
          className={css.formField}
          placeholder="Ср. оценка выше чем"
        />
      </div>
      <div className={css.formRow}>
        <Field
          name="pointsBelow"
          component={TextInput}
          className={css.formField}
          size="xs"
          placeholder="Ср. оценка ниже чем"
        />
      </div>

      <div className={css.formRow}>
        <Field cls={css.review_filter__checkbox} name="onlyNotVerified" component={CheckBox}>
          Непроверенные
        </Field>
        <Field cls={css.review_filter__checkbox} name="onlyActiveUser" component={CheckBox}>
          Не уволены
        </Field>
        <Button size="xs" view="action" className={css.review_filter__apply} type="submit">
          Применить
        </Button>
      </div>
    </form>
  );
};

ReviewFilter.propTypes = {
  items: PropTypes.arrayOf(PropTypes.instanceOf(Object)).isRequired,
  handleSubmit: PropTypes.func.isRequired,
  selectedGroups: PropTypes.number,
};

ReviewFilter.defaultProps = {
  selectedGroups: undefined,
};

export default ReviewFilter;
