import { combineReducers } from 'redux';
import Immutable from 'immutable';
import * as reviewActions from './actions';

const INIT_LIST = {
  isLoad: false,
  isFetch: false,
  managers: {},
};

const list = (state = INIT_LIST, action) => {
  let immutable;
  switch (action.type) {
    case reviewActions.LIST_REQUEST:
      return { ...state, isFetch: true };
    case reviewActions.LIST_RECIEVE:
      return {
        ...state,
        managers: { ...state.managers, ...action.data },
        isLoad: true,
        isFetch: false,
      };
    case reviewActions.LIST_FAIL:
      return { ...state, isFetch: false };
    case reviewActions.INSERT_ITEM:
      immutable = Immutable.fromJS(state);
      immutable = immutable.updateIn(['managers', 'teamlead'], teamlead => {
        if (teamlead && teamlead.size) {
          return teamlead.map(item => {
            if (item.get('manager').get('id') !== action.managerId) {
              return item;
            }
            return item.updateIn(['items'], items => {
              let isFind = false;
              let index = 0;
              items.forEach(item => {
                if (!isFind && item.get('id') === action.after) {
                  isFind = true;
                  return false;
                }
                index++;
              });
              return items.insert(index + 1, action.item);
            });
          });
        }
        return teamlead;
      });
      return immutable.toJS();

    case reviewActions.UPDATE_ITEM:
      immutable = Immutable.fromJS(state);
      immutable = immutable.updateIn(['managers', 'teamlead'], teamlead => {
        if (teamlead && teamlead.size) {
          return teamlead.map(item => {
            if (item.get('manager').get('id') !== action.managerId) {
              return item;
            }
            return item.updateIn(['items'], items => {
              let isFind = false;
              let index = 0;
              items.forEach(item => {
                if (!isFind && item.get('id') === action.id) {
                  isFind = true;
                  return false;
                }
                index++;
              });
              return items.update(index, value => {
                const iItem = Immutable.fromJS(action.item);
                return value.merge(iItem);
              });
            });
          });
        }
        return teamlead;
      });
      return immutable.toJS();

    default:
      return state;
  }
};

const INIT_ITEM = {
  isLoad: false,
  isFetch: false,
};

const item = (state = INIT_ITEM, action) => {
  switch (action.type) {
    case reviewActions.ITEM_REQUEST:
      return { ...state, isFetch: true };
    case reviewActions.ITEM_RECIEVE:
      return { ...action.data, isLoad: true, isFetch: false };
    case reviewActions.ITEM_FAIL:
      return { ...state, isFetch: false };
    case reviewActions.ITEM_RESET:
      return INIT_ITEM;
    default:
      return state;
  }
};

const INIT_UI = {
  tabName: 'teamlead',
};

const ui = (state = INIT_UI, action) => {
  switch (action.type) {
    case reviewActions.SET_PANEL:
      return { ...state, tabName: action.name };
    default:
      return state;
  }
};

export default combineReducers({ list, item, ui });
