/**
 * Используется в Шаблонах и в Почтовых правилах
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import ModalField from 'uiLib/ModalField';
import Popup from '@crm/components/dist/lego2/Popup';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import * as keyset from './FoldersPopup.i18n';
import css from './styles.modules.scss';

const i18nChoose = createI18N(keyset)('choose');

export default class FoldersPopup extends Component {
  constructor(props) {
    super(props);
    this.state = {
      show: false,
    };
    this.node = React.createRef();
  }

  componentWillReceiveProps(newProps) {
    if (!this.props.disabled && newProps.disabled) {
      this.hidePopup();
    }
  }

  togglePopup = () => {
    this.setState({ show: !this.state.show });
  };

  hidePopup = () => {
    this.setState({ show: false });
  };

  renderTree() {
    return null;
  }

  render() {
    const {
      className,
      input: { value },
      tree,
      disabled,
    } = this.props;
    const name = tree[value] ? tree[value].name : i18nChoose;

    return (
      <div className={cx(className, css.b)}>
        <ModalField
          onClick={this.togglePopup}
          title={name}
          fieldRef={this.node}
          disabled={disabled}
        >
          {name}
        </ModalField>
        <Popup
          padding="xs"
          clsWrap={css.b__popup}
          target="anchor"
          anchor={this.node}
          visible={this.state.show}
          directions="bottom"
          onOutsideClick={this.hidePopup}
        >
          {this.renderTree()}
        </Popup>
      </div>
    );
  }
}

FoldersPopup.propTypes = {
  className: PropTypes.string,
  tree: PropTypes.shape({
    root: PropTypes.shape({
      items: PropTypes.arrayOf(PropTypes.number),
    }),
  }),
  input: PropTypes.shape({
    value: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  }),
};

FoldersPopup.defaultProps = {
  className: undefined,
  tree: {},
  input: {},
};
