import React, { Component } from 'react';
import RouterLink from 'components/RouterLink';
import Authorization from 'modules/authorization/Authorization';
import css from './styles.modules.scss';
import meta from './meta';

export default class SettingsPane extends Component {
  renderCategory = (key, item) => (
    <div key={key} className={css.group}>
      {item.caption && <div className={css.groupTitle}>{item.caption}</div>}
      {item.map.map(i => this.renderItem(item.items[i], i))}
    </div>
  );

  renderItem = (item, key) => {
    if (!item.access) {
      return null;
    }

    const link = `/settings/${item.slug}`;
    return item.access !== 'all' ? (
      <Authorization access={`settingsAccess.${item.access}`}>
        <RouterLink key={key} className={css.groupItem} activeClassName={css.itemCurrent} to={link}>
          {item.caption}
        </RouterLink>
      </Authorization>
    ) : (
      <RouterLink key={key} className={css.groupItem} activeClassName={css.itemCurrent} to={link}>
        {item.caption}
      </RouterLink>
    );
  };

  render() {
    return (
      <div className={css.root}>
        <div className={css.content}>
          {meta.map.map(item => this.renderCategory(item, meta[item]))}
        </div>
      </div>
    );
  }
}
