import createI18N from '@yandex-int/i18n';
import * as keyset from './Pane.i18n';

const i18n = createI18N(keyset);

export default {
  common: {
    items: {
      templates: {
        caption: i18n('templates'),
        slug: 'templates',
        access: 'templates',
      },
      signatures: {
        caption: i18n('signatures'),
        slug: 'signatures',
        access: 'signatures',
      },
      tags: {
        caption: i18n('tags'),
        slug: 'tags',
        access: 'tags',
      },
      folders: {
        caption: i18n('folders'),
        slug: 'folders',
        access: 'folders',
      },
      accountTags: {
        caption: i18n('acc-tags'),
        slug: 'account-tags',
        access: 'accountTags',
      },
      emailTags: {
        caption: i18n('email-tags'),
        slug: 'email-tags',
        access: 'commMediumTags',
      },
      rules: {
        caption: i18n('rules'),
        slug: 'rules',
        access: 'mailRules',
      },
      autoreplies: {
        caption: i18n('autoreplies'),
        slug: 'autoreplies',
        access: 'autoreplies',
      },
      other: {
        caption: i18n('other'),
        slug: 'other',
        access: 'other',
      },
      supports: {
        caption: i18n('queues'),
        slug: 'supports',
        access: 'supports',
      },
      delegation: {
        caption: i18n('delegations'),
        slug: 'delegations',
        access: 'delegations',
      },
      mailing: {
        caption: i18n('mailing'),
        slug: 'mailing',
        access: 'mailing',
      },
      telephony: {
        caption: i18n('telephony'),
        slug: 'telephony',
        access: 'telephony',
      },
      notifications: {
        caption: i18n('notifications'),
        slug: 'notifications',
        access: 'notifications',
      },
      upsale: {
        caption: i18n('upsale'),
        slug: 'upsale',
        access: 'upsaleRule',
      },
      alerts: {
        caption: 'Алерты категорий',
        slug: 'alerts',
        access: 'categoryAlerts',
      },
    },
    map: [
      'templates',
      'signatures',
      'tags',
      'accountTags',
      'emailTags',
      'folders',
      'rules',
      'autoreplies',
      'other',
      'supports',
      'delegation',
      'mailing',
      'telephony',
      'notifications',
      'upsale',
      'alerts',
    ],
  },
  map: ['common'],
};
