import React from 'react';
import { Switch, Route } from 'react-router-dom';
import createI18N from '@yandex-int/i18n';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import * as keyset from '../../settings.i18n';
import Layout from '../../components/Layout';
import IndexPage from '../../components/IndexPage';
import TemplateRouter from '../../modules/templates/route';
import SignatureRouter from '../../modules/signatures/route';
import {
  FoldersRouter,
  TagsRouter,
  AccountTagsRouter,
  EmailTagsRouter,
} from '../../modules/foldersAndTags/route';
import MailRouteRouter from '../../modules/mailRules/route';
import DelegationRouter from '../../modules/delegation/route';
import AutoRepliesRouter from '../../modules/autoReplies/route';
import SupportRouter from '../../modules/supports/route';
import OtherRouter from '../../modules/other/route';
import MailingRouter from '../../modules/mailing/route';
import TelephonyRouter from '../../modules/telephony/route';
import NotificationsRouter from '../../modules/notifications';
import UpsaleRouter from '../../modules/upsale';
import { AlertsRouter } from '../../modules/alerts';

const Auth = moduleAuthorization('settingsAccess.any')(Layout);
const i18nSettings = createI18N(keyset)('settings');

const SettingsRouter = ({ match }) => (
  <Auth>
    <TitleChain>{i18nSettings}</TitleChain>
    <Switch>
      <Route exact path={match.url} component={IndexPage} />
      <Route path={`${match.url}/templates`} component={TemplateRouter} />
      <Route path={`${match.url}/signatures`} component={SignatureRouter} />
      <Route path={`${match.url}/folders`} component={FoldersRouter} />
      <Route path={`${match.url}/tags`} component={TagsRouter} />
      <Route path={`${match.url}/account-tags`} component={AccountTagsRouter} />
      <Route path={`${match.url}/email-tags`} component={EmailTagsRouter} />
      <Route path={`${match.url}/rules`} component={MailRouteRouter} />
      <Route path={`${match.url}/delegations`} component={DelegationRouter} />
      <Route path={`${match.url}/autoreplies`} component={AutoRepliesRouter} />
      <Route path={`${match.url}/supports`} component={SupportRouter} />
      <Route path={`${match.url}/other`} component={OtherRouter} />
      <Route path={`${match.url}/mailing`} component={MailingRouter} />
      <Route path={`${match.url}/telephony`} component={TelephonyRouter} />
      <Route path={`${match.url}/notifications`} component={NotificationsRouter} />
      <Route path={`${match.url}/upsale`} component={UpsaleRouter} />
      <Route path={`${match.url}/alerts`} component={AlertsRouter} />
    </Switch>
  </Auth>
);

export default SettingsRouter;
