import React, { FC } from 'react';
import { BodyProps } from './Body.types';
import { Row } from './Row/Row';

export const Body: FC<BodyProps> = (props) => {
  const { rows, disabled, onRowClick, activeRows = { byId: {} } } = props;

  return (
    <>
      {rows.map((row) => (
        <Row
          key={row.id}
          isActive={Boolean(activeRows.byId[row.id])}
          row={row}
          disabled={disabled}
          onClick={onRowClick}
        />
      ))}
    </>
  );
};
