import React, { FC } from 'react';
import cx from 'classnames';
import { CellProps } from './Cell.types';
import css from './Cell.module.css';

export const Cell: FC<CellProps> = (props) => {
  const { disabled, hovered, cell, ...restProps } = props;

  const className = cx(css.Cell, {
    [css.Cell_disabled]: props.disabled,
    [css.Cell_hovered]: props.hovered,
  });

  return (
    <span {...restProps} className={className} title={cell.caption}>
      {cell.caption}
    </span>
  );
};
