import React, { FC, useState } from 'react';
import { RowProps } from './Row.types';
import { Cell } from './Cell';

export const Row: FC<RowProps> = (props) => {
  const { row, disabled, onClick, isActive } = props;
  const [hovered, setHovered] = useState(false);

  const handleMouseOver = () => {
    setHovered(true);
  };

  const handleMouseLeave = () => {
    setHovered(false);
  };

  const handleClick = () => {
    if (onClick) {
      onClick(row);
    }
  };

  return (
    <>
      {row.cells.map((cell) => (
        <Cell
          key={cell.caption}
          cell={cell}
          hovered={hovered || isActive}
          disabled={disabled}
          onMouseOver={handleMouseOver}
          onMouseLeave={handleMouseLeave}
          onClick={handleClick}
        />
      ))}
    </>
  );
};
