import React, { FC } from 'react';
import { HeaderProps } from './Header.types';
import css from './Header.module.css';

export const Header: FC<HeaderProps> = (props) => {
  const { columns } = props;

  return (
    <>
      {columns.map((column) => (
        <span key={column.caption} className={css.Header__cell}>
          {column.caption}
        </span>
      ))}
    </>
  );
};
