import React, { FC, CSSProperties } from 'react';
import cx from 'classnames';
import { Header } from './Header';
import { Body } from './Body';
import { TitleTableProps } from './TitleTable.types';
import css from './TitleTable.module.css';

export const TitleTable: FC<TitleTableProps> = (props) => {
  const { title, scheme, disabled, onRowClick } = props;
  const { columns, rows, activeRows } = scheme;

  const style: CSSProperties = {
    gridTemplateColumns: `repeat(${columns.length}, 1fr)`,
  };

  const className = cx(css.TitleTable, props.className);

  return (
    <div className={className}>
      <h5 className={css.TitleTable__title}>{title}</h5>
      <div className={css.TitleTable__table} style={style}>
        <Header columns={columns} />
        <Body activeRows={activeRows} rows={rows} disabled={disabled} onRowClick={onRowClick} />
      </div>
    </div>
  );
};
