export interface HasCaption {
  caption: string;
}

export type Column = HasCaption;
export type Cell = HasCaption;
export interface Row {
  id: number;
  cells: Cell[];
}

export interface TableScheme {
  columns: Column[];
  rows: Row[];
  activeRows?: {
    byId: Record<number, boolean | undefined>;
  };
}

export interface TitleTableProps {
  className?: string;
  title?: string;
  disabled?: boolean;
  scheme: TableScheme;
  onRowClick?: (row: Row) => void;
}
