import React, { FC } from 'react';
import { AlertInfoProps } from './AlertInfo.types';
import css from './AlertInfo.module.css';
import { getCaptionForISOString } from '../../Route/Route.utils';

export const AlertInfo: FC<AlertInfoProps> = (props) => {
  const { alert } = props;

  return (
    <div className={css.AlertInfo}>
      <div className={css.AlertInfo__item}>
        <span className={css.AlertInfo__grayText}>id: </span>
        <span>{alert.id}</span>
      </div>
      <div className={css.AlertInfo__item}>
        <span className={css.AlertInfo__grayText}>Последнее изменение: </span>
        <span>
          {alert.modifiedBy?.name}, {getCaptionForISOString(alert.modifiedOn)}
        </span>
      </div>
    </div>
  );
};
