import React, { FC } from 'react';
import { Form, Values } from '../Form';
import { EditFormProps } from './EditForm.types';
import { AlertInfo } from './AlertInfo';

export const EditForm: FC<EditFormProps> = (props) => {
  const { alert, onSubmit } = props;

  if (!alert) {
    return <>Алерт отсутствует</>;
  }

  const initialValues: Partial<Values> = {
    id: alert.id,
    name: alert.name,
    expiredOn: alert.expiredOn,
    description: alert.description,
    category: alert.category,
  };

  return (
    <Form
      initialValues={initialValues}
      onSubmit={onSubmit}
      topAppend={<AlertInfo alert={alert} />}
    />
  );
};
