import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { Form as FinalForm } from 'react-final-form';
import { FieldRow } from 'components/FinalForm';
import { FormProps, Values } from './Form.types';
import css from './Form.module.css';

export const Form: FC<FormProps> = (props) => {
  const handleSubmit = (values: Values) => {
    props.onSubmit(values);
  };

  return (
    <div>
      <FinalForm onSubmit={handleSubmit} initialValues={props.initialValues}>
        {(form) => (
          <form onSubmit={form.handleSubmit}>
            <div className={css.Form__top}>
              <Button type="submit" view="action" className={css.Form__saveButton}>
                Сохранить
              </Button>
              {props.topAppend}
            </div>
            <FieldRow label="Название" component="TextInput" name="name" maxLength={500} required />
            <FieldRow label="Категория" component="TreeInput" name="category" required />
            <FieldRow label="Активен до" component="DateTimePicker" name="expiredOn" time />
            <FieldRow
              label="Описание"
              component="RichTextEditor"
              name="description"
              enableReinitialize
              fieldClassName={css.Form__editor}
            />
          </form>
        )}
      </FinalForm>
    </div>
  );
};
