import React, { FC } from 'react';
import Link from '@crm/components/dist/lego2/react-router/Link';
import { useHistory } from 'react-router-dom';
import { AsideProps } from './Aside.types';
import css from './Aside.module.css';

export const Aside: FC<AsideProps> = (props) => {
  const history = useHistory();

  return (
    <aside className={css.Aside}>
      <div className={css.Aside__top}>
        <h3 className={css.Aside__title}>Алерты категорий</h3>
        <Link
          className={css.Aside__addNew}
          disabled={history.location.pathname === `${props.path}/new`}
          to={`${props.path}/new`}
        >
          <i className="material-icons">add_box</i>
          Добавить новый
        </Link>
      </div>
      {props.append}
    </aside>
  );
};
