import React, { FC } from 'react';
import { RouteComponentProps } from 'react-router-dom';
import css from './Layout.module.css';
import { Aside } from './Aside';
import { LayoutProps } from './Layout.types';

export const Layout: FC<RouteComponentProps & LayoutProps> = (props) => {
  const path = props.match.path;

  return (
    <div className={css.Layout}>
      <Aside path={path} append={props.asideAppend} />
      <div className={css.Layout__content}>{props.children}</div>
    </div>
  );
};
