import React, { FC } from 'react';
import { Form, Values } from '../Form';
import { nextDay } from './NewForm.utils';
import { NewFormProps } from './NextForm.types';

export const NewForm: FC<NewFormProps> = (props) => {
  const initialValues: Partial<Values> = {
    expiredOn: nextDay(new Date()).toISOString(),
  };

  return <Form initialValues={initialValues} onSubmit={props.onSubmit} />;
};
