import React, { FC } from 'react';
import { TitleTable } from 'modules/settings/components/TitleTable';
import { AlertsTablesAsideProps } from './AlertsTablesAside.types';
import { filterInactiveAlerts, schemeFromAlerts, filterActiveAlerts } from '../Route.utils';
import css from './AlertsTablesAside.module.css';

export const AlertsTableAside: FC<AlertsTablesAsideProps> = (props) => {
  const { alerts, activeAlertId, onAlertClick } = props;

  const handleRowClick = (row: { id: number }) => {
    onAlertClick(row.id);
  };

  return (
    <>
      <TitleTable
        className={css.ActiveTable}
        title="Активные"
        scheme={schemeFromAlerts(filterActiveAlerts(alerts), activeAlertId)}
        onRowClick={handleRowClick}
      />

      <TitleTable
        title="Неактивные"
        disabled
        scheme={schemeFromAlerts(filterInactiveAlerts(alerts), activeAlertId)}
        onRowClick={handleRowClick}
      />
    </>
  );
};
