import * as t from './actionTypes.js';
import { baseCallApi, jsonApiCall } from 'api/common';

const AUTO_REPLIES_RESET = t.AUTO_REPLIES_RESET;
export const resetData = () => ({
  type: AUTO_REPLIES_RESET,
});

const AUTO_REPLIES_LOAD_REQUEST = t.AUTO_REPLIES_LOAD + '_REQUEST';
const AUTO_REPLIES_LOAD_RECIEVE = t.AUTO_REPLIES_LOAD + '_RECIEVE';
const AUTO_REPLIES_LOAD_FAIL = t.AUTO_REPLIES_LOAD + '_FAIL';
export const loadData = () => ({
  type: 'PROMISE',
  actions: [AUTO_REPLIES_LOAD_REQUEST, AUTO_REPLIES_LOAD_RECIEVE, AUTO_REPLIES_LOAD_FAIL],
  promise: baseCallApi({
    url: '/view/user/autoreplies/list',
    host: CRM_SPACE_API_HOST,
  }),
});

const AUTO_REPLIES_SAVE_REQUEST = t.AUTO_REPLIES_SAVE + '_REQUEST';
const AUTO_REPLIES_SAVE_RECIEVE = t.AUTO_REPLIES_SAVE + '_RECIEVE';
const AUTO_REPLIES_SAVE_FAIL = t.AUTO_REPLIES_SAVE + '_FAIL';
export const saveData = ({ data, type }) => ({
  type: 'PROMISE',
  actions: [AUTO_REPLIES_SAVE_REQUEST, AUTO_REPLIES_SAVE_RECIEVE, AUTO_REPLIES_SAVE_FAIL],
  promise: jsonApiCall({
    url: '/actions/user/autoreplies/update',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data,
  }),
  args: type,
});

const AUTO_REPLIES_UPDATE = t.AUTO_REPLIES_UPDATE;
export const updateData = data => ({
  type: AUTO_REPLIES_UPDATE,
  data,
});

const AUTO_REPLIES_STATUS_BASE = t.AUTO_REPLIES_STATUS_BASE;
export const baseStatus = () => ({
  type: AUTO_REPLIES_STATUS_BASE,
});

const AUTO_REPLIES_STATUS_ADD = t.AUTO_REPLIES_STATUS_ADD;
export const addStatus = () => ({
  type: AUTO_REPLIES_STATUS_ADD,
});

const AUTO_REPLIES_STATUS_EDIT = t.AUTO_REPLIES_STATUS_EDIT;
export const editStatus = () => ({
  type: AUTO_REPLIES_STATUS_EDIT,
});

const AUTO_REPLIES_STATUS_SETUP = t.AUTO_REPLIES_STATUS_SETUP;
export const setupStatus = () => ({
  type: AUTO_REPLIES_STATUS_SETUP,
});