import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N from '@yandex-int/i18n';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import { MODULE_NAME } from '../../constants';
import Status from '../Status';
import Preview from '../Preview';
import List from '../List';
import Tip from '../Tip';
import css from './styles.modules.scss';
import * as keyset from './Layout.i18n';

const i18n = createI18N(keyset);
const i18nSetup = i18n('setup');
const i18nNewTemplate = i18n('newTemplate');
const i18nTemplateEdit = i18n('templateEdit');

const SettingsRulesLayout = props => {
  const { moduleRoutes, autoReplies, children } = props;

  if (!autoReplies.isLoad) return null;

  const isActive = autoReplies.data && autoReplies.data.isActive;
  const templates = autoReplies.data && autoReplies.data.templates;

  const childrenWithProps = React.Children.map(children, child =>
    React.cloneElement(child, { autoReplies, moduleRoutes }),
  );

  return (
    <div className={css.root}>
      <div className={css.content}>
        <div className={css.aside}>
          <div className={css.header}>
            <div className={css.title}>{MODULE_NAME}</div>
            <Status className={css.status} isActive={isActive} />
            <RouterLink
              className={css.setup}
              activeClassName={css.setupActive}
              to={moduleRoutes.setup}
            >
              {i18nSetup}
            </RouterLink>
          </div>
          <Preview className={css.preview} data={autoReplies.data} />
          <List
            className={css.list}
            templates={templates}
            activeIndex={autoReplies.data && autoReplies.data.templateIndex}
            moduleRoutes={moduleRoutes}
            canAddTemplate={!!autoReplies.data.id}
          />
        </div>
        <div className={css.main}>
          <div className={css.path}>
            {SettingsModule} → {MODULE_NAME}
            {autoReplies.status === 'isNew' && (
              <span>
                {' '}
                → <span className={css.isNew}>{i18nNewTemplate}</span>
              </span>
            )}
            {autoReplies.status === 'isEdit' && <span> → {i18nTemplateEdit}</span>}
            {autoReplies.status === 'isSetup' && <span> → {i18nSetup}</span>}
          </div>
          <Tip autoReplies={autoReplies} moduleRoutes={moduleRoutes} />
          {childrenWithProps}
        </div>
      </div>
    </div>
  );
};

SettingsRulesLayout.propTypes = {
  autoReplies: PropTypes.instanceOf(Object),
};

SettingsRulesLayout.defaultProps = {
  autoReplies: {
    data: {},
  },
};

export default SettingsRulesLayout;
