import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N from '@yandex-int/i18n';
import Empty from 'components/Empty';
import cx from 'classnames';
import css from './styles.modules.scss';
import * as keyset from './List.i18n';

const i18n = createI18N(keyset);
const i18nListTitle = i18n('listTitle');
const i18nNoTemplates = i18n('noTemplates');
const i18nNewTemplate = i18n('newTemplate');

const SettingsAutoRepliesList = props => {
  const { className, templates, activeIndex, moduleRoutes, canAddTemplate, displayHeader } = props;

  return (
    <div className={cx(className, css.root)}>
      <div className={css.list}>
        {displayHeader && (
          <div className={css.listHeader}>
            <div className={css.listTitle}>{i18nListTitle}</div>
            <RouterLink
              className={cx(css.add, !canAddTemplate && css.addActive)}
              activeClassName={css.addActive}
              to={moduleRoutes.add}
            >
              {i18nNewTemplate}
            </RouterLink>
          </div>
        )}
        {!templates || !templates.length ? (
          <Empty text={i18nNoTemplates} icon={null} />
        ) : (
          templates.map((item, index) => (
            <RouterLink
              key={index}
              className={css.listItem}
              activeClassName={css.listItemCurrent}
              customMatch={({ location }) =>
                `${location.pathname}${location.search}` === `${moduleRoutes.edit}?index=${index}`
              }
              to={`${moduleRoutes.edit}?index=${index}`}
            >
              {index === activeIndex && (
                <span className={css.listItemDefault}>
                  <i className="material-icons">check</i>
                </span>
              )}
              {item.name}
            </RouterLink>
          ))
        )}
      </div>
    </div>
  );
};

SettingsAutoRepliesList.propTypes = {
  className: PropTypes.string,
  templates: PropTypes.arrayOf(PropTypes.object),
  activeIndex: PropTypes.number,
  moduleRoutes: PropTypes.shape({
    base: PropTypes.string,
    add: PropTypes.string,
    edit: PropTypes.string,
    setup: PropTypes.string,
  }),
  canAddTemplate: PropTypes.bool,
  displayHeader: PropTypes.bool,
};

SettingsAutoRepliesList.defaultProps = {
  className: undefined,
  templates: [],
  activeIndex: undefined,
  moduleRoutes: {},
  canAddTemplate: false,
  displayHeader: true,
};

export default SettingsAutoRepliesList;
