import React from 'react';
import { FormattedDate } from 'react-intl';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import { REPLY_TYPES } from '../../constants';
import css from './styles.modules.scss';
import * as keyset from './Preview.i18n';

const i18n = createI18N(keyset);
const i18nPeriod = i18n('period');
const i18nFrequency = i18n('frequency');

const SettingsAutoRepliesPreview = props => {
  const {
    className,
    data: { isActive, from, to, replyType },
  } = props;

  return isActive ? (
    <div className={cx(className, css.root)}>
      <div className={css.dates}>
        <span className={css.label}>{i18nPeriod}</span>{' '}
        <span className={css.value}>
          <FormattedDate value={from} day="numeric" month="short" year="numeric" />
          <span> – </span>
          <FormattedDate className={css.to} value={to} day="numeric" month="short" year="numeric" />
        </span>
      </div>
      <div className={css.type}>
        <span className={css.label}>{i18nFrequency}</span>{' '}
        <span className={css.value}>{REPLY_TYPES.map[replyType]}</span>
      </div>
    </div>
  ) : null;
};

export default SettingsAutoRepliesPreview;
