import React, { useCallback } from 'react';
import PropTypes from 'prop-types';
import Form from '../../containers/SetupForm';

const SettingsAutoRepliesSetup = (props) => {
  const { router, autoReplies, moduleRoutes } = props;

  const goRouteBack = useCallback(() => {
    router.push(moduleRoutes.base);
  }, [router, moduleRoutes]);

  if (!autoReplies.isLoad) return null;

  const data = autoReplies.data || {};
  const hasTemplateIndex = !isNaN(data.templateIndex);
  const hasTemplates = data.templates && data.templates.length > 0;

  return (
    <Form
      form="SettingsAutoRepliesSetup"
      initialValues={{
        templateType: hasTemplateIndex && hasTemplates ? 'old' : 'new',
        ...data,
        templateIndex: String(data.templateIndex),
      }}
      onReset={goRouteBack}
      onSubmitted={goRouteBack}
      onDeleted={goRouteBack}
    />
  );
};

SettingsAutoRepliesSetup.propTypes = {
  autoReplies: PropTypes.shape({
    data: PropTypes.shape({
      templates: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
};

SettingsAutoRepliesSetup.defaultProps = {
  autoReplies: {
    data: {},
  },
};

export default SettingsAutoRepliesSetup;
