import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import RenderDatePicker from 'requestForms/components/RenderDatePicker';
import RadioBox from 'lego/redux-form/RadioBox';
import CheckBox from 'lego/redux-form/CheckBox';
import Select from 'lego/redux-form/Select';
import DatePicker from 'requestForms/components/FieldDatePicker';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { Fields as TemplateFields } from '../TemplateForm';
import { REPLY_TYPES } from '../../constants';
import css from './styles.modules.scss';
import * as keyset from './SetupForm.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nActiveCheckbox = i18n('activeCheckbox');
const i18nPeriod = i18n('period');
const i18nFrom = commonI18n('from');
const i18nTo = commonI18n('to');
const i18nSend = i18n('send');
const i18nTemplate = i18n('template');
const i18nChoose = i18n('choose');
const i18nNew = i18n('new');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');

const SettingsAutoRepliesSetupForm = (props) => {
  const {
    handleSubmit,
    submitting,
    invalid,
    touch,
    to,
    templateType,
    templates,
    onReset,
    size,
  } = props;
  const hasTemplates = templates.length > 0;

  return (
    <form className={css.root} onSubmit={handleSubmit}>
      <div className={css.block}>
        <Field name="isActive" component={CheckBox} size={size}>
          {i18nActiveCheckbox}
        </Field>
      </div>
      <div className={cx(css.block, css.period)}>
        <div className={css.label}>{i18nPeriod}</div>
        <div className={css.field}>
          <div className={css.rows}>
            <div className={cx(css.row, css.date)}>
              <label htmlFor="from" className={cx(css.label, css.requiredStar)}>
                <span>{i18nFrom}</span>
              </label>
              <div className={css.field}>
                <DatePicker
                  name="from"
                  id="from"
                  className={css.formField}
                  component={RenderDatePicker}
                  props={{
                    hasClear: false,
                  }}
                  pickerProps={{
                    minDate: new Date(),
                  }}
                  onChange={() => {
                    touch('from');

                    if (to) {
                      touch('to');
                    }
                  }}
                />
              </div>
            </div>
            <div className={cx(css.row, css.date)}>
              <label htmlFor="to" className={cx(css.label, css.requiredStar)}>
                <span>{i18nTo}</span>
              </label>
              <div className={css.field}>
                <DatePicker
                  name="to"
                  id="to"
                  className={css.formField}
                  component={RenderDatePicker}
                  props={{
                    hasClear: false,
                  }}
                  pickerProps={{
                    minDate: new Date(),
                  }}
                  onChange={() => {
                    touch('to'); // Нужно сразу ибо "by default touched will be set when the field is blurred."
                  }}
                />
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className={css.row}>
        <label htmlFor="to" className={cx(css.label, css.requiredStar)}>
          <span>{i18nSend}</span>
        </label>
        <div className={css.field}>
          <Field
            className={css.radioGroup}
            name="replyType"
            component={RadioBox}
            size={size}
            options={REPLY_TYPES.values.map((item) => ({
              value: item,
              label: REPLY_TYPES.map[item],
            }))}
          />
        </div>
      </div>
      <div className={css.row}>
        <label htmlFor="to" className={cx(css.label, css.requiredStar)}>
          <span>{i18nTemplate}</span>
        </label>
        <div className={css.field}>
          <div className={css.templates}>
            <Field
              className={css.radioGroup}
              name="templateType"
              component={RadioBox}
              size={size}
              options={
                hasTemplates
                  ? [
                      { value: 'old', label: i18nChoose },
                      { value: 'new', label: i18nNew },
                    ]
                  : [{ value: 'new', label: i18nNew }]
              }
            />
            {templateType === 'old' && hasTemplates ? (
              <Field
                className={css.templatesOld}
                name="templateIndex"
                component={Select}
                size={size}
                maxHeight={400}
                options={templates.map((template, index) => ({
                  value: String(index),
                  content: template.name,
                }))}
              />
            ) : (
              <TemplateFields className={css.templateFields} prefix="templateNew" />
            )}
          </div>
        </div>
      </div>
      <div className={css.actions}>
        <span>
          <Button type="submit" size={size} view="action" disabled={submitting || invalid}>
            {i18nSave}
          </Button>
          <Button size={size} view="pseudo" disabled={submitting} onClick={onReset}>
            {i18nCancel}
          </Button>
        </span>
      </div>
    </form>
  );
};

SettingsAutoRepliesSetupForm.propTypes = {
  onReset: PropTypes.func,
  size: PropTypes.string,
};

SettingsAutoRepliesSetupForm.defaultProps = {
  onReset: () => {},
  size: 'm',
};

export default SettingsAutoRepliesSetupForm;
