import React from 'react';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import css from './styles.modules.scss';
import * as keyset from './Status.i18n';

const i18n = createI18N(keyset);
const i18nOn = i18n('on');
const i18nOff = i18n('off');

const SettingsAutoRepliesStatus = props => {
  const { className, isActive } = props;

  return isActive ? (
    <span className={cx(className, css.status, css.status_on)}>
      <i className="material-icons">check</i>&nbsp;{i18nOn}
    </span>
  ) : (
    <span className={cx(className, css.status, css.status_off)}>
      <i className="material-icons">do_not_disturb</i>&nbsp;{i18nOff}
    </span>
  );
};

export default SettingsAutoRepliesStatus;
