import React from 'react';
import PropTypes from 'prop-types';
import url from 'utils/url';
import Form from '../../containers/TemplateForm';

const SettingsAutoRepliesTemplate = props => {
  const { router, location, autoReplies, moduleRoutes } = props;

  if (!autoReplies.isLoad) return null;

  const data = autoReplies.data || {};
  const templates = data.templates;
  let formName = `SettingsAutoRepliesTemplate`;
  let isNew = true;
  let index;
  let template;

  const query = url.queryToObject(location.search);

  if (query && typeof query.index === 'number') {
    formName += query.index;
    isNew = false;
    index = parseInt(query.index, 10);
    template = templates[index];
  }

  return (
    <Form
      key={formName}
      form={formName}
      initialValues={template && { ...template }}
      data={{
        index,
        ...data,
      }}
      isNew={isNew}
      canDelete={!isNew && index !== data.templateIndex}
      onReset={() => {
        router.push(moduleRoutes.base);
      }}
      onSubmitted={() => {
        router.push(moduleRoutes.base);
      }}
      onDeleted={() => {
        router.push(moduleRoutes.base);
      }}
    />
  );
};

SettingsAutoRepliesTemplate.propTypes = {
  autoReplies: PropTypes.shape({
    data: PropTypes.shape({
      templates: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
};

SettingsAutoRepliesTemplate.defaultProps = {
  autoReplies: {
    data: {
      templates: [],
    },
  },
};

export default SettingsAutoRepliesTemplate;
