import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import RichTextEditor from 'lego/redux-form/RichTextEditor';
import TextInput from 'lego/redux-form/TextInput';
import css from './styles.modules.scss';
import * as keyset from './TemplateForm.i18n';

const i18n = createI18N(keyset);
const i18nTemplateName = i18n('templateName');
const i18nAutoreplyTemplate = i18n('autoreplyTemplate');

const SettingsAutoRepliesTemplateFormFields = (props) => {
  const { className } = props;
  let { prefix } = props;

  if (prefix) {
    prefix += '.';
  }

  return (
    <div className={className}>
      <div className={css.block}>
        <label htmlFor={`${prefix}name`} className={cx(css.label, css.requiredStar)}>
          {i18nTemplateName}
        </label>
        <Field
          className={css.field}
          name={`${prefix}name`}
          id={`${prefix}name`}
          component={TextInput}
          size="m"
        />
      </div>
      <div className={css.block}>
        <div className={css.header}>
          <label htmlFor={`${prefix}body`} className={cx(css.label, css.requiredStar)}>
            {i18nAutoreplyTemplate}
          </label>
        </div>
        <div className={css.editor}>
          <Field
            name={`${prefix}body`}
            id={`${prefix}body`}
            component={RichTextEditor}
            config="mail"
            props={{
              height: 'fix',
              keepLinesInPlainText: true,
            }}
          />
        </div>
      </div>
    </div>
  );
};

SettingsAutoRepliesTemplateFormFields.propTypes = {
  className: PropTypes.string,
  prefix: PropTypes.string,
};

SettingsAutoRepliesTemplateFormFields.defaultProps = {
  className: undefined,
  prefix: '',
};

export default SettingsAutoRepliesTemplateFormFields;
