import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import createI18N, { i18nRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import SettingsAutoRepliesTemplateFormFields from './Fields';
import * as keyset from './TemplateForm.i18n';
import css from './styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nRemove = commonI18n('remove');
const i18nCantRemove = i18nRaw(keyset)('cantRemove', {
  br: <br />,
});

const SettingsAutoRepliesTemplateForm = (props) => {
  const { handleSubmit, submitting, invalid, onDelete, onReset, isNew, canDelete } = props;

  return (
    <form className={css.form} onSubmit={handleSubmit}>
      <SettingsAutoRepliesTemplateFormFields />
      <div className={css.actions}>
        <div>
          <Button type="submit" size="m" view="action" disabled={submitting || invalid}>
            {i18nSave}
          </Button>
          <Button size="m" view="pseudo" disabled={submitting} onClick={onReset}>
            {i18nCancel}
          </Button>
        </div>
        <div className={css.hint}>
          {!isNew && (
            <Button
              type="button"
              size="m"
              view="pseudo"
              disabled={submitting || !canDelete}
              onClick={onDelete}
            >
              {i18nRemove}
            </Button>
          )}
          {!isNew && !canDelete && <div>{i18nCantRemove}</div>}
        </div>
      </div>
    </form>
  );
};

SettingsAutoRepliesTemplateForm.propTypes = {
  onDelete: PropTypes.func,
  onReset: PropTypes.func,
  canDelete: PropTypes.bool,
};

SettingsAutoRepliesTemplateForm.defaultProps = {
  onDelete: () => {},
  onReset: () => {},
  canDelete: false,
};

export default SettingsAutoRepliesTemplateForm;
export { SettingsAutoRepliesTemplateFormFields as Fields };
