import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import css from '../Layout/styles.modules.scss';
import * as keyset from './Tip.i18n';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nSomethingGoesWrong = createI18N(commonKeyset)('somethingGoesWrong');
const i18nSaved = i18n('saved');
const i18nRemoved = i18n('removed');

const SettingsRulesTip = props => {
  const { autoReplies, moduleRoutes } = props;
  const { status } = autoReplies;

  if (!autoReplies.isLoad) return null;
  if (status === 'isError') {
    return <div className={css.tip}>{i18nSomethingGoesWrong}</div>;
  }
  if (status === 'isSave') {
    return <div className={css.tip}>{i18nSaved}</div>;
  }
  if (status === 'isDelete') {
    return <div className={css.tip}>{i18nRemoved}</div>;
  }
  if (status !== 'isNew' && status !== 'isEdit' && status !== 'isSetup') {
    if (!autoReplies.data || !autoReplies.data.templates || !autoReplies.data.templates.length) {
      const i18nNotConfiguredYet = i18nRaw('notConfiguredYet', {
        optionalAction: (
          <RouterLink to={moduleRoutes.setup}>{i18n('configureAutoreply')}</RouterLink>
        ),
      });
      return <div className={css.tip}>{i18nNotConfiguredYet}</div>;
    }
    const i18nCanBeConfigured = i18nRaw('canBeConfigured', {
      where: <RouterLink to={moduleRoutes.setup}>{i18n('autoreplySettings')}</RouterLink>,
    });
    const i18nChooseFromList = i18nRaw('chooseFromList', {
      br: <br />,
      optionalAction: <RouterLink to={moduleRoutes.add}>{i18n('addNew')}</RouterLink>,
    });
    return (
      <div>
        <div className={css.tip}>{i18nCanBeConfigured}</div>
        <div className={css.tip}>{i18nChooseFromList}</div>
      </div>
    );
  }
  return null;
};

SettingsRulesTip.propTypes = {
  autoReplies: PropTypes.shape({
    data: PropTypes.shape({
      autoReplies: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
};

SettingsRulesTip.defaultProps = {
  autoReplies: {
    data: {
      autoReplies: [],
    },
  },
};

export default SettingsRulesTip;
