import createI18N from '@yandex-int/i18n';
import * as keyset from './autoReplies.i18n';

import { STATE_NAME as SN, ROUTER_PATH as RP } from '../../constants';

const i18n = createI18N(keyset);

export const MODULE_NAME = i18n('moduleName');
export const TITLE_CHAIN = i18n('titleChain');
export const STATE_NAME = `${SN}autoReplies/`;
export const ROUTER_PATH = '/autoreplies';
export const AUTHORIZATION_NAME = 'settingsAccess.autoreplies';

export const ROUTER_PATH_PARENT = RP;
export const ROUTER_PATH_ADD = '/add';
export const ROUTER_PATH_EDIT = '/edit';
export const ROUTER_PATH_SETUP = '/setup';

export const REPLY_TYPES = {
  map: {
    OncePerDay: i18n('oncePerDay'),
    OncePerWeek: i18n('oncePerWeek'),
    OncePerPeriod: i18n('oncePerPeriod'),
    EachMail: i18n('eachMail'),
  },
  values: ['OncePerDay', 'OncePerWeek', 'OncePerPeriod', 'EachMail'],
};
