import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { updateRootInfoIsAutoreply } from 'modules/initial';
import * as constants from '../constants';
import * as actions from '../actions';
import reducers from '../reducers';
import { moduleRoutes } from '../route';
import Layout from '../components/Layout';

global.reduxStore.injectReducer(constants.STATE_NAME, reducers);

const mapState = state => ({
  autoReplies: get(state, `${constants.STATE_NAME}`),
  info: get(state, 'root.info'),
});

const mapDispatch = dispatch => ({
  loadData: () => dispatch(actions.loadData()),
  addStatus: () => dispatch(actions.addStatus()),
  editStatus: () => dispatch(actions.editStatus()),
  setupStatus: () => dispatch(actions.setupStatus()),
  baseStatus: () => dispatch(actions.baseStatus()),
  resetData: () => dispatch(actions.resetData()),
  updateRootInfoIsAutoreply: status => dispatch(updateRootInfoIsAutoreply(status)),
});

class SettingsAutoRepliesLayout extends Component {
  componentDidMount() {
    this.props.loadData().then(() => {
      this.setStatus();
    });
  }

  componentDidUpdate(prevProps) {
    const currentPathname = this.props.location.pathname;
    const prevPathname = prevProps.location.pathname;

    if (currentPathname !== prevPathname) {
      this.setStatus();
    }

    const currentStatus = this.props.autoReplies.status;
    const currentIsActive = this.props.autoReplies.data && this.props.autoReplies.data.isActive;

    if (
      currentStatus === 'isSave' &&
      typeof currentIsActive !== undefined &&
      this.props.info.isAutoreply !== currentIsActive
    ) {
      this.props.updateRootInfoIsAutoreply(currentIsActive);
    }
  }

  componentWillUnmount() {
    this.props.resetData();
  }

  setStatus() {
    const {
      location: { pathname },
      autoReplies: { status },
      baseStatus,
      addStatus,
      editStatus,
      setupStatus,
    } = this.props;

    switch (pathname) {
      case moduleRoutes.add:
        if (status !== 'isNew') {
          addStatus();
        }
        break;

      case moduleRoutes.edit:
        if (status !== 'isEdit') {
          editStatus();
        }
        break;

      case moduleRoutes.setup:
        if (status !== 'isSetup') {
          setupStatus();
        }
        break;

      case moduleRoutes.base:
        if (status && status !== 'isSave' && status !== 'isDelete') {
          baseStatus();
        }
        break;

      default:
    }
  }

  render() {
    const { info, updateRootInfoIsAutoreply, ...rest } = this.props;

    return <Layout {...rest} moduleRoutes={moduleRoutes} />;
  }
}

SettingsAutoRepliesLayout.defaultProps = {
  autoReplies: {},
  info: {},
  loadData: () => {},
  addStatus: () => {},
  editStatus: () => {},
  setupStatus: () => {},
  baseStatus: () => {},
  resetData: () => {},
  updateRootInfoIsAutoreply: () => {},
};

export default connect(mapState, mapDispatch)(SettingsAutoRepliesLayout);
