import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as actions from '../actions';
import Form from '../components/SetupForm';
import * as keyset from '../autoReplies.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nRequired = commonI18n('inputRequired');
const i18nFromToError = i18n('fromToError');

const validate = values => {
  const errors = {};
  const requiredFields = ['replyType', 'from', 'to'];

  if (values.templateType === 'old') {
    requiredFields.push('templateIndex');
  }

  requiredFields.forEach(field => {
    if (!values[field] || (values[field].hasOwnProperty('length') && !values[field].length)) {
      errors[field] = i18nRequired;
    }
  });

  if (values.templateType === 'new') {
    const requiredFieldsTemplate = ['name', 'body'];
    const templateNewErrors = {};

    requiredFieldsTemplate.forEach(field => {
      if (
        !values.templateNew ||
        !values.templateNew[field] ||
        (values.templateNew[field].hasOwnProperty('length') && !values.templateNew[field].length)
      ) {
        templateNewErrors[field] = i18nRequired;
      }
    });

    if (Object.keys(templateNewErrors).length > 0) {
      errors.templateNew = templateNewErrors;
    }
  }

  // if (values.from) {
  //   const from = new Date(values.from);
  //   const today = new Date();
  //
  //   if (from !== 'Invalid Date' && values.from.length > 9 &&
  //     from.setHours(0, 0, 0, 0) < today.setHours(0, 0, 0, 0) &&
  //     props.initialValues.canEditStartDate !== false) {
  //     errors.from = 'Дата "С" не может быть раньше сегодняшнего дня';
  //   }
  // }

  // if (values.to) {
  //   const to = new Date(values.to);
  //   const today = new Date();
  //
  //   if (to !== 'Invalid Date' && values.to.length > 9 &&
  //     to.setHours(0, 0, 0, 0) < today.setHours(0, 0, 0, 0) &&
  //     props.initialValues.canEditEndDate !== false) {
  //     errors.to = 'Дата "По" не может быть раньше сегодняшнего дня';
  //   }
  // }

  if (values.from && values.to && new Date(values.from) > new Date(values.to)) {
    errors.to = i18nFromToError;
  }

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);

  return {
    ...selector(state, 'to', 'templateType'),
    templates: (props.initialValues && props.initialValues.templates) || [],
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: data => {
    const resultData = { ...data };

    if (resultData.templateType === 'new') {
      const newTemplate = { ...resultData.templateNew };

      if (!resultData.templates) {
        resultData.templates = [];
      }

      resultData.templates.push(newTemplate);
      resultData.templateIndex = resultData.templates.length - 1;
    }

    // FIX arrayValue in RenderSelect
    if (Array.isArray(resultData.templateIndex)) {
      resultData.templateIndex = resultData.templateIndex[0];
    }

    delete resultData.templateType;
    delete resultData.templateNew;
    delete resultData.createdOn;
    delete resultData.modifiedOn;

    dispatch(actions.saveData({ data: resultData, type: 'isSave' }))
      .then(response => {
        if (!response.responseStatus) {
          dispatch(actions.updateData(response));
        }
        return response;
      })
      .then(response => {
        if (!response.responseStatus && typeof props.onSubmitted === 'function') {
          props.onSubmitted();
        }
      });
  },
});

export default connect(mapState, mapDispatch)(reduxForm({ validate })(Form));
