import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as actions from '../actions';
import Form from '../components/TemplateForm';
import * as keyset from '../autoReplies.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nRequired = commonI18n('inputRequired');
const i18nRemoveConfirm = i18n('removeConfirm');

const validate = values => {
  const errors = {};
  const requiredFields = ['name', 'body'];

  requiredFields.forEach(field => {
    if (!values[field] || (values[field].hasOwnProperty('length') && !values[field].length)) {
      errors[field] = i18nRequired;
    }
  });

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const to = selector(state, 'to');

  return {
    to,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: data => {
    if (!props.data) {
      console.error('Данные автоответа необходимо передать как параметр data: {}');
    }

    const template = data;
    const { index, templates, ...rest } = props.data;
    const newTemplates = templates.slice();

    if (index || index === 0) {
      newTemplates.splice(index, 1, template);
    } else {
      newTemplates.push(template);
    }

    const resultData = { templates: newTemplates, ...rest };
    delete resultData.templateType;
    delete resultData.templateNew;
    delete resultData.createdOn;
    delete resultData.modifiedOn;

    dispatch(actions.saveData({ data: resultData, type: 'isSave' }))
      .then(response => {
        if (!response.responseStatus) {
          dispatch(actions.updateData(response));
        }
        return response;
      })
      .then(response => {
        if (!response.responseStatus && typeof props.onSubmitted === 'function') {
          props.onSubmitted();
        }
      });
  },
  onDelete: () => {
    if (!props.data) {
      console.error('Данные автоответа необходимо передать как параметр data: {}');
    }

    const result = confirm(i18nRemoveConfirm);
    const { index, templates, ...rest } = props.data;

    if ((!index && index !== 0) || !result) return;

    const newTemplates = templates.slice();
    newTemplates.splice(index, 1);

    const resultData = { templates: newTemplates, ...rest };

    if (resultData.templateIndex > index) {
      --resultData.templateIndex;
    }

    delete resultData.createdOn;
    delete resultData.modifiedOn;

    dispatch(actions.saveData({ data: resultData, type: 'isDelete' }))
      .then(response => {
        if (!response.responseStatus) {
          dispatch(actions.updateData(response));
        }
        return response;
      })
      .then(response => {
        if (!response.responseStatus && typeof props.onDeleted === 'function') {
          props.onDeleted();
        }
      });
  },
});

export default connect(mapState, mapDispatch)(reduxForm({ validate })(Form));
