import React from 'react';
import { connect } from 'react-redux';
import getDisplayName from 'utils/getDisplayName';
import get from 'lodash/get';
import { STATE_NAME } from './constants';
import { moduleRoutes } from './route.js';

const factoryRouteAdapter = WrappedComponent => {
  const Adapter = props => (
    <WrappedComponent {...props} router={props.history} moduleRoutes={moduleRoutes} />
  );

  const mapState = state => ({
    autoReplies: get(state, `${STATE_NAME}`),
  });

  Adapter.displayName = `RouteAdapter(${getDisplayName(WrappedComponent)})`;
  return connect(mapState)(Adapter);
};

export default factoryRouteAdapter;
