import * as t from './actionTypes';

const autoReplies = (state = {}, action) => {
  switch (action.type) {
    case t.AUTO_REPLIES_RESET:
      return {};

    case t.AUTO_REPLIES_LOAD + '_REQUEST':
      return {
        ...state,
        isFetch: true,
        status: '',
      };
    case t.AUTO_REPLIES_LOAD + '_RECIEVE':
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        status: '',
      };
    case t.AUTO_REPLIES_LOAD + '_FAIL':
      return {
        ...state,
        isFetch: false,
        status: 'isError',
      };

    case t.AUTO_REPLIES_SAVE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.AUTO_REPLIES_SAVE + '_RECIEVE':
      return {
        ...state,
        response: action.data,
        status: action.args,
      };
    case t.AUTO_REPLIES_SAVE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        status: 'isError',
      };

    case t.AUTO_REPLIES_UPDATE:
      return {
        ...state,
        data: action.data,
      };

    case t.AUTO_REPLIES_STATUS_BASE:
      return {
        ...state,
        status: '',
      };

    case t.AUTO_REPLIES_STATUS_ADD:
      return {
        ...state,
        status: 'isNew',
      };

    case t.AUTO_REPLIES_STATUS_EDIT:
      return {
        ...state,
        status: 'isEdit',
      };

    case t.AUTO_REPLIES_STATUS_SETUP:
      return {
        ...state,
        status: 'isSetup',
      };

    default:
      return state;
  }
};

export default autoReplies;
