import React from 'react';
import { Switch, Route } from 'react-router-dom';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import Layout from './containers/Layout';
import Template from './components/Template';
import Setup from './components/Setup';
import factoryRouteAdapter from './factoryRouteAdapter';
import {
  ROUTER_PATH,
  ROUTER_PATH_PARENT,
  ROUTER_PATH_ADD,
  ROUTER_PATH_EDIT,
  ROUTER_PATH_SETUP,
  AUTHORIZATION_NAME,
  TITLE_CHAIN,
} from './constants';

const Auth = moduleAuthorization(AUTHORIZATION_NAME)(Layout);

const TemplateAdapter = factoryRouteAdapter(Template);
const TemplateSetup = factoryRouteAdapter(Setup);

const AutoRepliesRouter = props => {
  const { match } = props;

  return (
    <Auth {...props}>
      <TitleChain>{TITLE_CHAIN}</TitleChain>
      <Switch>
        <Route path={`${match.url}${ROUTER_PATH_ADD}`} component={TemplateAdapter} />
        <Route path={`${match.url}${ROUTER_PATH_EDIT}`} component={TemplateAdapter} />
        <Route path={`${match.url}${ROUTER_PATH_SETUP}`} component={TemplateSetup} />
      </Switch>
    </Auth>
  );
};

const pathBase = `${ROUTER_PATH_PARENT}${ROUTER_PATH}`;

const moduleRoutes = {
  base: pathBase,
  add: `${pathBase}${ROUTER_PATH_ADD}`,
  edit: `${pathBase}${ROUTER_PATH_EDIT}`,
  setup: `${pathBase}${ROUTER_PATH_SETUP}`,
};

export default AutoRepliesRouter;
export { moduleRoutes };
